package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.dao.DatosAvisoDao;
import com.ejie.ab04b.dao.DatosNotificacionDao;
import com.ejie.ab04b.dao.custom.DatosLocalizacionCustomDao;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.PlateaTramitacionUtils;
import com.ejie.foldermanagement.xml.ApplicantInfoEvent;
import com.ejie.foldermanagement.xml.ChannelInfoTypeEvent;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;
import com.ejie.foldermanagement.xml.NoticeEvent;
import com.ejie.foldermanagement.xml.NotificationEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0466s00ServiceImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Service(value = "ab0466s00Service")
public class DatosNotificacionServiceImpl implements DatosNotificacionService {

	@Autowired()
	private DatosNotificacionDao datosNotificacionDao;
	@Autowired()
	private DatosAvisoDao datosAvisoDao;
	@Autowired()
	private DatosLocalizacionCustomDao datosLocalizacionDao;

	/**
	 * Inserts a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosNotificacion add(DatosNotificacion ab0466s00) {
		return this.datosNotificacionDao.add(ab0466s00);
	}

	/**
	 * Updates a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DatosNotificacion update(DatosNotificacion ab0466s00) {
		return this.datosNotificacionDao.update(ab0466s00);
	}

	/**
	 * Finds a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	public DatosNotificacion find(DatosNotificacion ab0466s00) {
		return (DatosNotificacion) this.datosNotificacionDao.find(ab0466s00);
	}

	/**
	 * Finds a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	public DatosNotificacion findConLocalizacionYAvisos(
			DatosNotificacion ab0466s00) {
		// Cargamos los datos de notificación
		DatosNotificacion datosNotificacion = (DatosNotificacion) this.datosNotificacionDao
				.find(ab0466s00);

		// Si tiene datos de localización, los cargamos también
		if (datosNotificacion != null) {
			if (datosNotificacion.getDatosLocalizacion() != null
					&& datosNotificacion.getDatosLocalizacion()
							.getCodLocalizacion067() != null) {
				datosNotificacion
						.setDatosLocalizacion(this.datosLocalizacionDao
								.vfind(datosNotificacion.getDatosLocalizacion()));
			} else {
				datosNotificacion.setDatosLocalizacion(new DatosLocalizacion());
			}

			// Cargamos también los datos de aviso
			DatosAviso filterDatosAviso = new DatosAviso();
			filterDatosAviso.setDatosNotificacion(datosNotificacion);
			List<DatosAviso> listaDatoAviso = this.datosAvisoDao.findAll(
					filterDatosAviso, null);
			datosNotificacion.setListaDatosAviso(listaDatoAviso);
		}
		return datosNotificacion;
	}

	/**
	 * Deletes a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(DatosNotificacion ab0466s00) {
		this.datosNotificacionDao.remove(ab0466s00);
	}

	/**
	 * Finds a list of rows in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0466s00>
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<DatosNotificacion> findAll(DatosNotificacion ab0466s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<DatosNotificacion>) this.datosNotificacionDao.findAll(
				ab0466s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0466s00 table using like.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0466s00>
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<DatosNotificacion> findAllLike(DatosNotificacion ab0466s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<DatosNotificacion>) this.datosNotificacionDao.findAllLike(
				ab0466s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0466s00 table.
	 * 
	 *  filterAb0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0466s00>
	 *
	 * @param filterAb0466s00 the filter ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<DatosNotificacion> filter(
			DatosNotificacion filterAb0466s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<DatosNotificacion> listaAb0466s00 = this.datosNotificacionDao
				.findAllLike(filterAb0466s00, jqGridRequestDto, false);
		Long recordNum = this.datosNotificacionDao.findAllLikeCount(
				filterAb0466s00 != null ? filterAb0466s00
						: new DatosNotificacion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<DatosNotificacion>> reorderSelection = this.datosNotificacionDao
					.reorderSelection(filterAb0466s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<DatosNotificacion>(jqGridRequestDto,
					recordNum, listaAb0466s00, reorderSelection);
		}
		return new JQGridResponseDto<DatosNotificacion>(jqGridRequestDto,
				recordNum, listaAb0466s00);
	}

	/**
	 * Searches rows in the Ab0466s00 table.
	 * 
	 *  filterAb0466s00
	 *            Ab0466s00
	 *  searchAb0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0466s00>>
	 *
	 * @param filterAb0466s00 the filter ab 0466 s 00
	 * @param searchAb0466s00 the search ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<DatosNotificacion>> search(
			DatosNotificacion filterAb0466s00,
			DatosNotificacion searchAb0466s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.datosNotificacionDao.search(filterAb0466s00,
				searchAb0466s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0466s00 table.
	 * 
	 *  filterAb0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0466s00 the filter ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(DatosNotificacion filterAb0466s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.datosNotificacionDao.reorderSelection(filterAb0466s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Insertar datos notificacion context submission.
	 * 
	 *  contextSubmission            ContextSubmissionEvent
	 *  DatosNotificacion
	 *
	 * @param contextSubmission the context submission
	 * @return the datos notificacion
	 */
	public DatosNotificacion insertarDatosNotificacionContextSubmission(
			ContextSubmissionEvent contextSubmission) {

		ApplicantInfoEvent applicant = contextSubmission
				.getApplicantsInfoEvent().getApplicantInfoEvent().get(0);

		// Datos de notificación
		NotificationEvent notificationEvent = applicant.getNotificationEvent();
		DatosNotificacion datosNotif = new DatosNotificacion();
		datosNotif.setCanalnotif066(PlateaTramitacionUtils.getInstance()
				.obtenerCanalNotificacion(notificationEvent.getChannelType()));
		datosNotif.setIdioma066(PlateaTramitacionUtils.getInstance()
				.obtenerIdiomaNotificacion(applicant.getLanguage()));

		if (Constantes.CANAL_NOTIF_POSTAL.equals(datosNotif.getCanalnotif066())) {
			// Datos de localizacion
			ChannelInfoTypeEvent channelInfo = notificationEvent
					.getChannelInfoTypeEvent();
			DatosLocalizacion datosLocalizacion = new DatosLocalizacion();

			datosLocalizacion.setProvincia(new Provincia(PlateaTramitacionUtils
					.getInstance()
					.obtenerCodigoNoraContextSubmissionChannelInfo(
							channelInfo.getProvincia())));
			datosLocalizacion.setMunicipio(new Municipio(PlateaTramitacionUtils
					.getInstance()
					.obtenerCodigoNoraContextSubmissionChannelInfo(
							channelInfo.getMunicipio())));
			datosLocalizacion.setLocalidad(new Localidad(PlateaTramitacionUtils
					.getInstance()
					.obtenerCodigoNoraContextSubmissionChannelInfo(
							channelInfo.getLocalidad())));
			datosLocalizacion.setCalle067(channelInfo.getDireccion());
			datosLocalizacion.setPortal067(channelInfo.getPortal());
			datosLocalizacion.setPiso067(channelInfo.getPiso());
			datosLocalizacion.setPuerta067(channelInfo.getLetra());
			datosLocalizacion.setCodpostal067(channelInfo.getCp());

			datosLocalizacion = this.datosLocalizacionDao
					.add(datosLocalizacion);
			datosNotif.setDatosLocalizacion(datosLocalizacion);
		}

		datosNotif = this.datosNotificacionDao.add(datosNotif);

		// Datos de aviso
		if (applicant.getNoticesEvent() != null) {
			for (NoticeEvent notice : applicant.getNoticesEvent()
					.getNoticeEvent()) {
				DatosAviso datosAviso = new DatosAviso();
				datosAviso
						.setTipo068(PlateaTramitacionUtils.getInstance()
								.obtenerTipoAvisoContextSubmission(
										notice.getNoticeChannelEvent()
												.getNoticeType()));
				if (Constantes.CANAL_AVISO_EMAIL
						.equals(datosAviso.getTipo068())) {
					datosAviso.setValor068(notice.getNoticeChannelEvent()
							.getEmailAddress());
				} else if (Constantes.CANAL_AVISO_SMS.equals(datosAviso
						.getTipo068())) {
					datosAviso.setValor068(notice.getNoticeChannelEvent()
							.getSmsNumber());
				}
				datosAviso.setDatosNotificacion(datosNotif);
				this.datosAvisoDao.add(datosAviso);
			}
		}

		return datosNotif;
	}

}
